; AHK scripts that type (like this one) CANNOT run in a powershell remoting session 

#Requires AutoHotkey v2.0
#include C:\AOFG\OCR.ahk

WriteLog(text) {
	FileAppend A_NowUTC ": " text "`n", "C:\AOFG\AHK_log.txt"
}

WriteLog "Script started"

CoordMode "Mouse", "Window"
Sleep 10000
SendEvent "{Esc}" ; In case of expiring Windows Build
Sleep 1000
Run "ms-settings:display"
if WinWait("ahk_class ApplicationFrameWindow", , 1)
{
    WinMaximize
    WinActivate
    Sleep 2000

    ; Open settings:display and scroll down
    result := OCR.FromWindow("A","en-us",2)
    try found := result.FindString("Multiple displays")
    catch {
        WriteLog 'Multiple displays not found!'
    }

    ; MouseMove is set to CoordMode Window, so no coordinate conversion necessary
    MouseMove found.x, found.y
    result.Highlight(found)

    Loop 10 {
        SendEvent "{WheelDown}"
        Sleep 50
    }
    Sleep 500
    ; Click on "Advanced Display"
    result := OCR.FromWindow("A","en-us",2)

    try found := result.FindString("Advanced Display")
    catch {
        WriteLog 'Advanced Display not found!'
    }

    MouseMove found.x, found.y
    result.Highlight(found)
    MouseClick "left"

    ; Try to find "ParsecVDA", if found, click on it and then on "HyperVMonitor"
    result := OCR.FromWindow("A","en-us",2)

    parsecVDAfound := false
    try 
    {
        found := result.FindStringPattern("Display.*ParsecVDA")
        parsecVDAfound := true
        found := result.FindString(found.Text)

        MouseMove found.x, found.y
        result.Highlight(found)
        MouseClick "left"
    }
    catch 
    {
        WriteLog "FindStringPattern not found, this is okay"
    }

    if parsecVDAfound
    {
        ; Trying to find the HyperVMonitor in the Settings app just like with the "Display.*ParsecVDA" pattern DOES NOT work for whatever reason
        SendEvent "{Up}"
        Sleep 300
        SendEvent "{Enter}"
        Sleep 300

        result := OCR.FromWindow("A","en-us",2)
        found := result.FindString("HyperVMonitor")
        result.Highlight(found)
    }

    ; Disable Hyper-V Monitor
    try 
    {
        result := OCR.FromWindow("A","en-us",2)
        found := result.FindString("Off")
        MouseMove found.x, found.y
        result.Highlight(found)
        MouseClick "left"
        
    }
    catch
    {
        WriteLog "Unable to disable hyperv monitor!"
    }

    WriteLog "Finished"
}
