# https://hitco.at/blog/apply-edge-policies-for-non-domain-joined-devices/

<# MDM-FakeEnrollment-Win10 #>

# Fake MDM-Enrollment - Key 1 of 2 - let a Win10 Machine "feel" MDM-Managed
$regPath1 = "HKLM:\SOFTWARE\Microsoft\Enrollments\FFFFFFFF-FFFF-FFFF-FFFF-FFFFFFFFFFFF"

if (-not (Test-Path $regPath1)) {
    New-Item -Path $regPath1 -Force | Out-Null
}

Set-ItemProperty -Path $regPath1 -Name "EnrollmentState" -Value 1 -Type DWord
Set-ItemProperty -Path $regPath1 -Name "EnrollmentType" -Value 0 -Type DWord
Set-ItemProperty -Path $regPath1 -Name "IsFederated" -Value 0 -Type DWord

# Fake MDM-Enrollment - Key 2 of 2 - let a Win10 Machine "feel" MDM-Managed
$regPath2 = "HKLM:\SOFTWARE\Microsoft\Provisioning\OMADM\Accounts\FFFFFFFF-FFFF-FFFF-FFFF-FFFFFFFFFFFF"

if (-not (Test-Path $regPath2)) {
    New-Item -Path $regPath2 -Force | Out-Null
}

Set-ItemProperty -Path $regPath2 -Name "Flags" -Value 0x00d6fb7f -Type DWord
Set-ItemProperty -Path $regPath2 -Name "AcctUId" -Value "0x000000000000000000000000000000000000000000000000000000000000000000000000"
Set-ItemProperty -Path $regPath2 -Name "RoamingCount" -Value 0 -Type DWord
Set-ItemProperty -Path $regPath2 -Name "SslClientCertReference" -Value "MY;User;0000000000000000000000000000000000000000"
Set-ItemProperty -Path $regPath2 -Name "ProtoVer" -Value "1.2"

<# EdgeChromium-Policies-Recommended-GoogleSearch-NoFirstRunWizzard #>

# EdgeChromium "Recommended" Policies for Preconfigure Google as Search engine and disable FirstRun-Wizard.
# Note: These settings can be changed by users because they are "Recommended" policies.

# Key 1: Disable the First Run Experience in Edge
$regPath3 = "HKLM:\SOFTWARE\Policies\Microsoft\Edge"

if (-not (Test-Path $regPath3)) {
    New-Item -Path $regPath3 -Force | Out-Null
}

Set-ItemProperty -Path $regPath3 -Name "HideFirstRunExperience" -Value 1 -Type DWord

# Key 2: Set Google as the default search engine and disable import features in Edge
$regPath4 = "HKLM:\SOFTWARE\Policies\Microsoft\Edge\Recommended"

if (-not (Test-Path $regPath4)) {
    New-Item -Path $regPath4 -Force | Out-Null
}

Set-ItemProperty -Path $regPath4 -Name "DefaultSearchProviderName" -Value "Google"
Set-ItemProperty -Path $regPath4 -Name "DefaultSearchProviderSearchURL" -Value "{google:baseURL}search?q={searchTerms}&{google:RLZ}{google:originalQueryForSuggestion}{google:assistedQueryStats}{google:searchFieldtrialParameter}{google:searchClient}{google:sourceId}ie={inputEncoding}"
Set-ItemProperty -Path $regPath4 -Name "DefaultSearchProviderEnabled" -Value 1 -Type DWord
Set-ItemProperty -Path $regPath4 -Name "DefaultSearchProviderSuggestURL" -Value "{google:baseURL}complete/search?output=chrome&q={searchTerms}"
Set-ItemProperty -Path $regPath4 -Name "DefaultSearchProviderImageURL" -Value "{google:baseURL}searchbyimage/upload"
Set-ItemProperty -Path $regPath4 -Name "DefaultSearchProviderImageURLPostParams" -Value "encoded_image={google:imageThumbnail},image_url={google:imageURL},sbisrc={google:imageSearchSource},original_width={google:imageOriginalWidth},original_height={google:imageOriginalHeight}"
Set-ItemProperty -Path $regPath4 -Name "HomepageLocation" -Value "https://google.com"
Set-ItemProperty -Path $regPath4 -Name "NewTabPageLocation" -Value "https://google.com"

# Disable importing various settings and data during Edge setup
$importSettings = @(
    "ImportPaymentInfo",
    "ImportHistory",
    "ImportSavedPasswords",
    "ImportOpenTabs",
    "ImportAutofillFormData",
    "ImportBrowserSettings",
    "ImportCookies",
    "ImportExtensions",
    "ImportFavorites",
    "ImportSearchEngine",
    "ImportShortcuts"
)

foreach ($setting in $importSettings) {
    Set-ItemProperty -Path $regPath4 -Name $setting -Value 0 -Type DWord
}
