<#
    A games disk can attach in a way that forbids reading any files larger than around a few MB
    This script ensures all the files on the disk are accessible
#>

param(
    [Parameter(Mandatory = $true)]
    [string]$VMName,
    [Parameter(Mandatory = $true)]
    [string]$AdminPassword
)

$password = ConvertTo-SecureString $AdminPassword -AsPlainText -Force
$cred = New-Object System.Management.Automation.PSCredential ("Administrator", $password)


Write-Host "Changing games disk permissions"
$content = Invoke-Command -VMName $VMName -Credential $cred -ScriptBlock {
    $takeownLog = "C:\AOFG\takeown_error.log"

    # Take ownership
    takeown /F "D:\PreinstalledGameLibraries\SteamLibrary" /R /D Y *> $takeownLog
    takeown /F "D:\PreinstalledGameLibraries\EpicLibrary" /R /D Y *> $takeownLog
    takeown /F "D:\PreinstalledGameLibraries\GogLibrary" /R /D Y *> $takeownLog

    # Reset ACLs
    icacls "D:\PreinstalledGameLibraries\SteamLibrary" /T /C /grant:r Administrator:F *>> $takeownLog
    icacls "D:\PreinstalledGameLibraries\EpicLibrary" /T /C /grant:r Administrator:F *>> $takeownLog
    icacls "D:\PreinstalledGameLibraries\GogLibrary" /T /C /grant:r Administrator:F *>> $takeownLog
}

Write-Host $content
