param(
    [Parameter(Mandatory = $true)]
    [string]$VMName,
    [Parameter(Mandatory = $true)]
    [string]$AdminPassword
)
$password = ConvertTo-SecureString $AdminPassword -AsPlainText -Force
$cred = New-Object System.Management.Automation.PSCredential ("Administrator", $password)

Invoke-Command -VMName $VMName -Credential $cred -ArgumentList $parsecEmail, $parsecPassword -scriptblock {
    # Get all disks using Get-Disk cmdlet
    $disks = Get-Disk

    foreach ($disk in $disks) {
        # Check if the disk is offline
        if ($disk.OperationalStatus -eq 'Offline') {
            try {
                # Bring the disk online
                Set-Disk -Number $disk.Number -IsOffline $false
                Write-Host "Disk $($disk.Number) brought online successfully."
            } catch {
                Write-Host "Failed to bring disk $($disk.Number) online: $_"
            }
        } else {
            Write-Host "Disk $($disk.Number) is already online."
        }
    }
}