param (
    [Parameter(Mandatory=$true)]
    [string]$SteamCmdPath,

    [Parameter(Mandatory=$true)]
    [string[]]$GameIds,

    [Parameter(Mandatory=$true)]
    [string]$SteamUser,

    [Parameter(Mandatory=$true)]
    [string]$Password
)

# 1. Start by logging in
$Arguments = @(
    "+login", $SteamUser, $Password
)

# 2. Dynamically add the update command for EACH game in the list
foreach ($AppId in $GameIds) {
    $Arguments += "+app_update"
    $Arguments += $AppId
    $Arguments += "validate"
}

# 3. End the session
$Arguments += "+quit"

Write-Host "Starting batch installation for: $($GameIds -join ', ')..." -ForegroundColor Cyan

# Execution - only ONE login will occur for all games
& $SteamCmdPath $Arguments
