# This script installs cygwin, ssh and rsync through cygwin

# inital setup
cmd /c "winget install --id=Cygwin.Cygwin -e -h --scope ""machine"" --accept-source-agreements --accept-package-agreements"

# package setup
$cygwinInstallerUrl = "https://www.cygwin.com/setup-x86_64.exe"
$folder = "C:\AOFG"
$executable = "$folder\cygwin_env_setup.exe"
if(-not (Test-Path -Path $folder))
{ 
    New-Item -Path $folder -ItemType Directory| Out-Null 
}

(New-Object System.Net.WebClient).DownloadFile($cygwinInstallerUrl, $executable)

$rsync = Start-Process -FilePath $executable -ArgumentList "--packages", "rsync", "-q" -Wait -PassThru
if($rsync.ExitCode -ne 0)
{
    throw "Rsync install error"
}

$ssh = Start-Process -FilePath $executable -ArgumentList "--packages", "openssh", "-q" -Wait -PassThru
if($ssh.ExitCode -ne 0)
{
    throw "OpenSSH install error"
}

# cleanup
Get-ChildItem | Where-Object { $_ -match "http" } | Remove-Item -Recurse
