Set-Location $PSScriptRoot

.("..\AOFLibrary\AOFLibrary.ps1")

$ScriptName = "PowershellSetup"
$LogFile = BeginScriptLogging -ScriptName $ScriptName

<# Bypass DDA restrictions #>

# Define the registry path and value
$registryPath = "HKLM:\SOFTWARE\Policies\Microsoft\Windows\HyperV"
$RequireSecureDeviceAssignment = "RequireSecureDeviceAssignment"
$RequireSupportedDeviceAssignment = "RequireSupportedDeviceAssignment"
$valueData = 0 # for both

# Ensure the registry path exists, create it if it doesn't
if (-not (Test-Path $registryPath)) {
    New-Item -Path $registryPath -Force | Out-Null
}

# Set the registry value
Set-ItemProperty -Path $registryPath -Name $RequireSecureDeviceAssignment -Value $valueData -Force

Set-ItemProperty -Path $registryPath -Name $RequireSupportedDeviceAssignment -Value $valueData -Force


<# Cygwin & Rsync #>
try {
    Set-Location $PSScriptRoot
    ../Rsync/InstallFullRsyncEnvironment.ps1
}
catch {
    HandleScriptExecutionError -Message "Rsync env install error: $($_.Exception.Message)" -Log $LogFile
}

Write-ScriptSuccess -Log $LogFile
