param(
    [Parameter(Mandatory = $true)]
    [string]$VHDxPath,
    [Parameter(Mandatory = $false)]
    [string]$MountFolder = $null
)
Set-Location $PSScriptRoot
.("..\AOFLibrary\AOFLibrary.ps1")
$ScriptName = "DismountVHDx"
$LogFile = BeginScriptLogging -ScriptName $ScriptName
try {
    $vhdx = Get-VHD -Path $VHDxPath
    if($MountFolder)
    {
        $vhdx | Get-Disk | Get-Partition | Where-Object { ($_ | Get-Volume) -ne $Null } | 
                Remove-PartitionAccessPath -AccessPath $MountFolder -ErrorAction Stop
    }
    $vhdx = Dismount-VHD -Path $VHDxPath -Passthru -ErrorAction Stop
}
catch {
    HandleScriptExecutionError -Message "Disk mount error: $($_.Exception.Message)" -Log $LogFile
}

Write-ScriptSuccess -Log $LogFile
