#Requires AutoHotkey v2.0
#include C:\AOFG\OCR.ahk
#SingleInstance force

; This script enters user's credentials into Parsec and sends OCR'ed window contents back

parsecWindow := "ahk_class MTY_Window"
if WinWait(parsecWindow, , 5) ; Wait up to 5 seconds for Parsec to start up
{
    WinActivate
    WinMove 0, 0

    ; Try to force redraw
    WinMinimize
    Sleep 100
    WinMaximize
    Sleep 100
    
    ; Enter credentials
    Sleep 50
    SendEvent "{Tab}"
    Sleep 50
    SendEvent "{Tab}"
    Sleep 50
    Send "^a"
    Sleep 50
    Send "{Backspace}"
    Sleep 50
    SendText Format("{1}", A_Args[1]) ; Enter email
    Sleep 50
    SendEvent "{Tab}"
    Sleep 50
    Send "^a"
    Sleep 50
    Send "{Backspace}"
    Sleep 50
    SendText Format("{1}", A_Args[2]) ; Enter password
    Sleep 50
    SendEvent "{Tab}" ; Reset back to entering email
    Sleep 50
    SendInput "{Enter}" ; Confirm
    Sleep 50

    result := "##undefined##"
    if windowText := OCR.WaitText("Error", 10000, OCR.FromWindow.Bind(OCR), false) ; Capture screen
    {
        result := windowText.Text
    }
    else
    {
        result := "##timeout##"
    }

    StdOut := FileOpen("*", "w")
    StdOut.WriteLine(result) ; Send whole window capture back
    StdOut.Close()

    WinMinimize ; hide the Parsec window
}
