# Ensure games disk is connected AND online first

param(
    [Parameter(Mandatory = $true)]
    [string]$VMName,
    [Parameter(Mandatory = $true)]
    [string]$AdminPassword
)

$password = ConvertTo-SecureString $AdminPassword -AsPlainText -Force
$cred = New-Object System.Management.Automation.PSCredential ("Administrator", $password)

Write-Host "Making a symbolic link for the Steam preinstalled library; result:"
$content = Invoke-Command -VMName $VMName -Credential $cred -ScriptBlock {
    if((Test-Path -Path "C:\Program Files (x86)\Steam\steamapps"))
    {
        Remove-Item -Path "C:\Program Files (x86)\Steam\steamapps" -Recurse -Force
    }
    cmd /c "mklink /J ""C:\Program Files (x86)\Steam\steamapps"" ""D:\PreinstalledGameLibraries\SteamLibrary\steamapps"""
}
Write-Host $content
