# Ensure games disk is connected AND online first

param(
    [Parameter(Mandatory = $true)]
    [string]$VMName,
    [Parameter(Mandatory = $true)]
    [string]$AdminPassword
)

$password = ConvertTo-SecureString $AdminPassword -AsPlainText -Force
$cred = New-Object System.Management.Automation.PSCredential ("Administrator", $password)

Write-Host "Making a symbolic link for the Epic Games Store preinstalled library; result:"
$content = Invoke-Command -VMName $VMName -Credential $cred -ScriptBlock {
    if((Test-Path -Path "C:\ProgramData\Epic\EpicGamesLauncher\Data\Manifests"))
    {
        Remove-Item -Path "C:\ProgramData\Epic\EpicGamesLauncher\Data\Manifests" -Recurse -Force
    }
    cmd /c "mklink /J ""C:\ProgramData\Epic\EpicGamesLauncher\Data\Manifests"" ""D:\PreinstalledGameLibraries\EpicLibrary\Manifests"""
}
Write-Host $content
