param(
    [Parameter(Mandatory = $true)]
    [string]$VMName,
    [Parameter(Mandatory = $true)]
    [string]$AdminPassword,
    [Parameter(Mandatory = $true)]
    [string]$logFile
)

$password = ConvertTo-SecureString $AdminPassword -AsPlainText -Force
$cred = New-Object System.Management.Automation.PSCredential ("Administrator", $password)

$invokeCommandLog = Invoke-Command -VMName $VMName -Credential $cred -ScriptBlock {
    Set-Location "C:\AOFG\build\VM"
    .\InstallDotNet35FromISO.cmd
}
Write-Log -Message ($invokeCommandLog -join "`n") -LEVEL INFO -Log $logFile
