param(
    [Parameter(Mandatory = $true)]
    [string]$VMName
)

$sourceDir = $PSScriptRoot
$destDir = "C:\AOFG\build"
# Recursively get all files from the source directory
Get-ChildItem -Path $sourceDir -Recurse -File | ForEach-Object {
    $relativePath = $_.FullName.Substring($sourceDir.Length)
    $destinationPath = Join-Path $destDir $relativePath
    
    # Copy the file to the destination path
    Copy-VMFile -VMName $VMName -SourcePath $_.FullName -DestinationPath $destinationPath -CreateFullPath -FileSource Host
    Write-Host "File copied: $_"
}
