# ChangeGamerPassword.ps1
param(
    [Parameter(Mandatory=$true)]
    $newPassword
)

$username = "Gamer"
if (-not $newPassword) {
    throw "Password cannot be empty"
}
Get-LocalUser -Name $username -ErrorAction Stop | Out-Null

try {
    Set-LocalUser -Name $username -Password (ConvertTo-SecureString -String $newPassword -AsPlainText -Force)
}
catch {
    throw "Password change FAILED: $($_.Exception.Message)"
}

# In addition to changing the password of $username, autologon password must be changed also
function Set-RegistryValue {
    param (
        [string]$Path,
        [string]$Name,
        [string]$Value
    )

    if (-not (Test-Path $Path)) {
        New-Item -Path $Path -Force | Out-Null
    }

    if (-not (Get-ItemProperty $Path -Name $Name -ErrorAction SilentlyContinue)) {
        New-ItemProperty -Path $Path -Name $Name -Value $Value -PropertyType String -Force | Out-Null
    } else {
        Set-ItemProperty -Path $Path -Name $Name -Value $Value
    }
}

$regPath = "HKLM:\SOFTWARE\Microsoft\Windows NT\CurrentVersion\Winlogon"
Set-RegistryValue -Path $regPath -Name "DefaultUsername" -Value $username -Force
Set-RegistryValue -Path $regPath -Name "DefaultPassword" -Value $newPassword  -Force
Set-RegistryValue -Path $regPath -Name "AutoAdminLogon" -Value "1" -Force

